/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class BankTransferFBDataDto extends BaseDto {
	
	private static final long serialVersionUID = 3322927888185971287L;
	
	// tB[h
	protected String kCode              = "";	// ЈR[h
	protected Date   calcDate               ;	// vZN
	protected Date   payday                 ;	// ^x
	protected String calcStatus         = "";	// vZXe[^X
	protected String kName              = "";	// Ј
	protected String stationCode        = "";	// R[h
	protected String positionCode       = "";	// EʃR[h
	protected int    bankPayAmount     = 0 ;	// sUz
	protected String allowanceType ;	// x敪
	protected String coBankCode    ;	// ЋsR[h
	protected String paidBankCode  ;	// UsR[h
	protected String paidBranchCode;	// UsxXR[h
	protected int    meansSequence ;	// x@A
	protected String accountType   ;	// a敪
	protected String accountNo     ;	// ԍ
	protected String holderKana    ;	// `ض
	protected String paymentMeans  ;	// x@
	protected String amountType    ;	// z敪
	
	



	// tB[h

	
	
	/**
	 * RXgN^
	 */
	public BankTransferFBDataDto(){
		super();
	}
	
	// ANZT\bh
	public int    getMeansSequence () { return meansSequence ; }	// x@A
	public String getAllowanceType () { return allowanceType ; }	// x敪
	public String getCoBankCode    () { return coBankCode    ; }	// ЋsR[h
	public String getPaidBankCode  () { return paidBankCode  ; }	// UsR[h
	public String getPaidBranchCode() { return paidBranchCode; }	// UsxXR[h
	public String getAccountType   () { return accountType   ; }	// a敪
	public String getAccountNo     () { return accountNo     ; }	// ԍ
	public String getHolderKana    () { return holderKana    ; }	// `ض
	public String getPaymentMeans  () { return paymentMeans  ; }	// x@
	public String getAmountType    () { return amountType    ; }	// z敪

	public void setMeansSequence (int    meansSequence ) { this.meansSequence  = meansSequence ; }	// x@A
	public void setAllowanceType (String allowanceType ) { this.allowanceType  = allowanceType ; }	// x敪
	public void setCoBankCode    (String coBankCode    ) { this.coBankCode     = coBankCode    ; }	// ЋsR[h
	public void setPaidBankCode  (String paidBankCode  ) { this.paidBankCode   = paidBankCode  ; }	// UsR[h
	public void setPaidBranchCode(String paidBranchCode) { this.paidBranchCode = paidBranchCode; }	// UsxXR[h
	public void setAccountType   (String accountType   ) { this.accountType    = accountType   ; }	// a敪
	public void setAccountNo     (String accountNo     ) { this.accountNo      = accountNo     ; }	// ԍ
	public void setHolderKana    (String holderKana    ) { this.holderKana     = holderKana    ; }	// `ض
	public void setPaymentMeans  (String paymentMeans  ) { this.paymentMeans   = paymentMeans  ; }	// x@
	public void setAmountType    (String amountType    ) { this.amountType     = amountType    ; }	// z敪

	
	// ANZT\bh
	public String getKCode             () { return kCode                 ; }	// ЈR[h
	public Date   getCalcDate          () { return getDateField(calcDate); }	// vZN
	public Date   getPayday            () { return getDateField(payday  ); }	// ^x
	public String getCalcStatus        () { return calcStatus            ; }	// vZXe[^X
	public String getKName             () { return kName                 ; }	// Ј
	public String getStationCode       () { return stationCode           ; }	// R[h
	public String getPositionCode      () { return positionCode          ; }	// EʃR[h
	public int    getBankPayAmount    () { return bankPayAmount        ; }	// sUz

	public void setKCode             (String kCode             ) { this.kCode              = kCode                 ; }	// ЈR[h
	public void setCalcDate          (Date   calcDate          ) { this.calcDate           = getDateField(calcDate); }	// vZN
	public void setPayday            (Date   payday            ) { this.payday             = getDateField(payday)  ; }	// ^x
	public void setCalcStatus        (String calcStatus        ) { this.calcStatus         = calcStatus            ; }	// vZXe[^X
	public void setKName             (String kName             ) { this.kName              = kName                 ; }	// Ј
	public void setStationCode       (String stationCode       ) { this.stationCode        = stationCode           ; }	// R[h
	public void setPositionCode      (String positionCode      ) { this.positionCode       = positionCode          ; }	// EʃR[h
	public void setBankPayAmount    (int    bankPayAmount    ) { this.bankPayAmount     = bankPayAmount        ; }	// sUz
	

}
